﻿Imports System.Text.RegularExpressions

Public Class Form1

    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        txtOutput.ReadOnly = True
        txtInput.ScrollBars = ScrollBars.Both
        txtOutput.ScrollBars = ScrollBars.Both
    End Sub

    ' Trigger replacement whenever something changes
    Private Sub TextChanged_Handler(sender As Object, e As EventArgs) _
        Handles txtInput.TextChanged, txtSearch.TextChanged, txtReplace.TextChanged, chkRegex.CheckedChanged

        ReplaceText()
    End Sub

    Private Sub ReplaceText()
        Try
            Dim inputText As String = txtInput.Text
            Dim searchText As String = txtSearch.Text
            Dim replaceText As String = txtReplace.Text

            If String.IsNullOrEmpty(searchText) Then
                txtOutput.Text = inputText
                Return
            End If

            If chkRegex.Checked Then
                ' Regex replace (greedy by default)
                txtOutput.Text = Regex.Replace(inputText, searchText, replaceText)
            Else
                ' Plain text replace (all occurrences)
                txtOutput.Text = inputText.Replace(searchText, replaceText)
            End If

        Catch ex As Exception
            txtOutput.Text = "Error: " & ex.Message
        End Try
    End Sub

End Class
